<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableRewards extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rewards', function (Blueprint $table) {
            $table->increments('id');
            $table->string('intitule')->default('none');
            $table->double("probability");
            $table->string("type");     //type of value
            $table->string("value");    //image or text
            $table->boolean("win");     // is it a win
            $table->string("resultText");
            $table->string("image")->nullable();
            $table->integer('magasin_id')->unsigned()->nullable();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('rewards');
        DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}
